return helicopter( "Ka-50", _("Ka-50"),
    {
        
        EmptyWeight = "8030",
        LandRWCategories = 
        {
            [1] = 
            {
                Name = "AircraftCarrier",
            }, -- end of [1]
            [2] = 
            {
                Name = "HelicopterCarrier",
            }, -- end of [2]
        }, -- end of LandRWCategories
        MaxFuelWeight = "1450",
        MaxHeight = "6600",
        MaxSpeed = "300",
        MaxTakeOffWeight = "11900",
        Picture = "Ka-50.png",
        Rate = "50",
        Shape = "KA-50",
        TakeOffRWCategories = 
        {
            [1] = 
            {
                Name = "AircraftCarrier",
            }, -- end of [1]
            [2] = 
            {
                Name = "HelicopterCarrier",
            }, -- end of [2]
        }, -- end of TakeOffRWCategories
        WorldID = 155,
        
        Navpoint_Panel = true,
		Fixpoint_Panel = true,
        
        -- Countermeasures,  
        SingleChargeTotal = 128,
        CMDS_Incrementation = 32,
        ChaffNoEdit = true,
        ChaffDefault = 0, 
        ChaffChargeSize = 1,
        FlareDefault = 128, 
        FlareChargeSize = 1,
        CMDS_Edit = true,
        
        attribute = {wsType_Air, wsType_Helicopter, wsType_Battleplane, KA_50,
        "Attack helicopters",
        },
        Categories = {
        },
        Crew = 1,
        CanopyGeometry = makeHelicopterCanopyGeometry(LOOK_BAD, LOOK_GOOD, LOOK_BAD),
        Sensors = {
            OPTIC = "Shkval",
        },
        Countermeasures = {
            DISPENSER = "UV-26"
        },
		HumanRadio = {
			frequency = 124.0,
			editable = true,
			minFrequency = 100,
			maxFrequency = 400,
			modulation = MODULATION_AM
		},	

--added by HF for ME frequency adjustment (R-828 code by Imp, ARK-22 by Flagrum)
		panelRadio = {
			[1] = {  
				name = _("R-828"),
				range = {min = 20.0, max = 60.0},
				channels = {
                   [1] = { name = _("Channel 1"), default = 35.654, modulation = _("FM")},
                    [2] = { name = _("Channel 2"), default = 25.675, modulation = _("FM")},
                    [3] = { name = _("Channel 3"), default = 48.5435, modulation = _("FM")},
                    [4] = { name = _("Channel 4"), default = 35.6575, modulation = _("FM")},
                    [5] = { name = _("Channel 5"), default = 0.0, modulation = _("FM")},
                    [6] = { name = _("Channel 6"), default = 0.0, modulation = _("FM")},
                    [7] = { name = _("Channel 7"), default = 0.0, modulation = _("FM")},
                    [8] = { name = _("Channel 8"), default = 0.0, modulation = _("FM")},
                    [9] = { name = _("Channel 9"), default = 0.0, modulation = _("FM")},
                    [10] = { name = _("Channel 10"), default = 0.0, modulation = _("FM")},
				}
			},
			[2] = {  
				name = _("ARK-22"),
				range = {min = 0.150, max = 1.750},
				channels = {
					[1] =  { name = _("Channel 1 - Outer"),           default = 0.625 },
					[2] =  { name = _("                      Inner"), default = 0.303 },
					[3] =  { name = _("Channel 2 - Outer"),           default = 0.288 },
					[4] =  { name = _("                      Inner"), default = 0.591 },
					[5] =  { name = _("Channel 3 - Outer"),           default = 0.408 },
					[6] =  { name = _("                      Inner"), default = 0.830 },
					[7] =  { name = _("Channel 4 - Outer"),           default = 0.443 },
					[8] =  { name = _("                      Inner"), default = 0.215 },
					[9] =  { name = _("Channel 5 - Outer"),           default = 0.525 },
					[10] = { name = _("                      Inner"), default = 1.064 },
					[11] = { name = _("Channel 6 - Outer"),           default = 0.718 },
					[12] = { name = _("                      Inner"), default = 0.350 },
					[13] = { name = _("Channel 7 - Outer"),           default = 0.583 },
					[14] = { name = _("                      Inner"), default = 0.283 },
					[15] = { name = _("Channel 8 - Outer"),           default = 0.995 },
					[16] = { name = _("                      Inner"), default = 1.210 },
				}
			},			
		},
--end adds by HF
		
        Failures = {
            { id = 'hydro_main',  label = _('HYDRO MAIN'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'hydro_common',  label = _('HYDRO COMMON'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'l_engine',  label = _('L-ENGINE'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'r_engine',  label = _('R-ENGINE'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_p',  	label = _('ASC PITCH'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_r',  	label = _('ASC ROLL'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_y',  	label = _('ASC YAW'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_a',  	label = _('ASC ALT'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'abris_software',  	label = _('ABRIS SOFTWARE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
 			{ id = 'abris_hardware',  	label = _('ABRIS HARDWARE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'laser_failure' ,  	label = _('LASER FAILURE'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'RADAR_ALT_TOTAL_FAILURE', 	label = _("RALT FAILURE"), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
       },
        mapclasskey = "P0091000021",
		sounderName = "Aircraft/Helicopters/Ka-50",
    },
    {
        pylon(1, 0, 0.947000, -0.348000, -2.735000,
            {
                FiZ = -3,
				arg = 308,
             },
            {
    			{ CLSID = "B_8V20A_CM" },
    			{ CLSID = "B_8V20A_OFP2" },
    			{ CLSID = "B_8V20A_OM" },
                { CLSID = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}" },
                { CLSID = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
                { CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}" },
                { CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
                { CLSID = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" },
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
                { CLSID = "{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}" },
            }
        ),
        pylon(2, 0, 0.916000, -0.348000, -2.023000,
            {
                FiZ = -3,
				arg = 309,
            },
            {
    			{ CLSID = "B_8V20A_CM" },
    			{ CLSID = "B_8V20A_OFP2" },
    			{ CLSID = "B_8V20A_OM" },
                { CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}" },
                { CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
                { CLSID = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" },
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
                { CLSID = "{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}" },
            }
        ),
        pylon(3, 0, 0.916000, -0.348000, 2.023000,
            {
                FiZ = -3,
				arg = 310,
            },
            {
    			{ CLSID = "B_8V20A_CM" },
    			{ CLSID = "B_8V20A_OFP2" },
    			{ CLSID = "B_8V20A_OM" },
                { CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}" },
                { CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
                { CLSID = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" },
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
                { CLSID = "{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}" },
            }
        ),
        pylon(4, 0, 0.947000, -0.348000, 2.735000,
            {
                FiZ = -3,
				arg = 311,
            },
            {
    			{ CLSID = "B_8V20A_CM" },
    			{ CLSID = "B_8V20A_OFP2" },
    			{ CLSID = "B_8V20A_OM" },
                { CLSID = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}" },
                { CLSID = "{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" },
                { CLSID = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}" },
                { CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}" },
                { CLSID = "{05544F1A-C39C-466b-BC37-5BD1D52E57BB}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}" },
                { CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}" },
                { CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}" },
                { CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}" },
                { CLSID = "{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}" },
            }
        ),
    },
    {
        aircraft_task(CAS),
        aircraft_task(GroundAttack),
		aircraft_task(Escort),
        aircraft_task(AFAC),
        aircraft_task(AntishipStrike)
    },
	aircraft_task(CAS)
);
